<?php
$dbhost = '127.0.0.1';
$dbusername = 'shonth22';
$dbpassword = 'WcPgNcTr';
$databaze = 'shonth22';

$conn = new mysqli($dbhost, $dbusername, $dbpassword, $databaze);

if ($conn->connect_error) {
    die("Připojení selhalo: " . $conn->connect_error);
}

header('Content-Type: application/json');

if (isset($_POST['url']) && isset($_POST['port'])) {
    $url = $_POST['url'];
    $username = $_POST['username'];
    $port = intval($_POST['port']); // Převedení na celé číslo pro zajištění, že port je celé číslo

    // Kontrola validnosti URL a portu
    if (!filter_var($url, FILTER_VALIDATE_URL) || $port <= 0) {
        echo json_encode(['success' => false, 'message' => "Neplatná URL adresa nebo port."]);
        exit;
    }

    $domain = parse_url($url, PHP_URL_HOST);
    $datumOvereni = date('Y-m-d H:i:s');

    // Použití cURL s explicitním nastavením portu
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_PORT, $port);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
    $data = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpcode >= 200 && $httpcode < 300) {
        // Uložení nebo aktualizace informací v databázi
        $stmt = $conn->prepare("INSERT INTO testovaciDatabaze (domain, port, username, datumOvereni) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE datumOvereni=VALUES(datumOvereni), username=VALUES(username)");
        $stmt->bind_param("siss", $domain, $port, $username, $datumOvereni);
        if ($stmt->execute()) {
            $response = ['success' => true, 'message' => "Doména $domain na portu $port je dostupná a informace byla uložena/aktualizována."];
        } else {
            $response = ['success' => false, 'message' => "Chyba při ukládání do databáze: " . $stmt->error];
        }
        $stmt->close();
    } else {
        $response = ['success' => false, 'message' => "Doména $url není dostupná na portu $port."];
    }
} else {
    $response = ['success' => false, 'message' => "Chybějící URL nebo port."];
}

echo json_encode($response);

$conn->close();
?>