<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: login.php");
    exit;
}

$success_message = '';
if (isset($_SESSION['registration_success'])) {
    $success_message = $_SESSION['registration_success'];
    unset($_SESSION['registration_success']);
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Registrace Admina</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f4f4;
            display: flex;
            flex-direction: column; 
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        form {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.2);
            width: 300px;
            text-align: center;
        }
        h2 {
            margin-bottom: 20px;
        }
        input[type=text], input[type=password], input[type=email] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }
        input[type=submit] {
            width: 100%;
            background-color: #007bff;
            color: white;
            padding: 12px 20px;
            margin: 20px 0;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        input[type=submit]:hover {
            background-color: #0056b3;
        }
        .success-message {
            background-color: #dff0d8;
            color: #3c763d;
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 4px;
            border: 1px solid #d6e9c6;
        }
        .logout {
            text-decoration: none;
            color: #007bff;
            margin-top: 20px;
        }
        .logout:hover {
            text-decoration: underline;
        }
    </style>
    </style>
</head>
<body>
<?php if (!empty($success_message)): ?>
    <div class="success-message"><?php echo htmlspecialchars($success_message); ?></div>
<?php endif; ?>
    <form action="register.php" method="post">
        <h2>Registrace uživatelů</h2>

        <label for="email">Email:</label>
        <input type="email" id="email" name="email" required><br>

        <label for="username">Uživatelské jméno:</label>
        <input type="text" id="username" name="username" required><br>
        
        <label for="password">Heslo:</label>
        <input type="password" id="password" name="password" required><br>

        <input type="submit" value="Registrovat">
        <a href="logout.php" class="logout">Odhlásit se</a>
    </form>
</body>
</html>
