<?php
	include_once '../../db.php';
	session_start();
	$errors = [];

	if (isset($_POST ["email"]) && empty($_POST ["email"])) {
		$errors['email'] = "Zadejte emailovou adresu !";
	} elseif (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
    	$errors['email'] = "Emailová adresa není platná !";
	}

	$password = $_POST['password'];

	$uppercase = preg_match('@[A-Z]@', $password);
	$lowercase = preg_match('@[a-z]@', $password);
	$number = preg_match('@[0-9]@', $password);

	if (isset($_POST ["password"]) && empty($_POST ["password"])) {
		$errors['password'] = "Zadejte heslo !";
	} elseif (!$uppercase || !$lowercase || !$number || strlen($password) < 8) {
    	$errors['password'] = 'Heslo by mělo mít alespoň 8 znaků a mělo by obsahovat alespoň jedno velké písmeno, jedno malé písmeno a jednu číslici.';
	} 
		
	//Podmínky repaet_password
	if (isset($_POST ["repeat_password"]) && empty($_POST ["repeat_password"])) {
		$errors['check'] = "Potvrďte heslo !";
	} elseif ( isset($_POST ['password']) && !empty($_POST ['password']) && $_POST ['password'] !== $_POST ['repeat_password']) {
		$errors['check'] = "Hesla se neshodují !";
	}
	$phonenumber = $_POST['telefon'];
	$phonenumber_format = "+420 " . substr($phonenumber, 0, 3) . " " . substr($phonenumber, 3, 3) . " " . substr($phonenumber, 6);
	if (isset($phonenumber) && empty($phonenumber)) {
		$errors['telefon'] = "Zadejte telefonní číslo!";
	} elseif (!preg_match('/^\d{9}$/', $phonenumber)) {
   		$errors['telefon'] = "Telefonní číslo není ve spravném formátu (66677700)";
	} 
	$dateOfBirth = $_POST['datum'];

	$today = new DateTime();
	$birthdate = new DateTime($dateOfBirth);
	$age = $birthdate->diff($today)->y;
	if (isset($phonenumber) && empty($phonenumber)) {
		$errors['datum'] = "Zadejte datum narození!";
	} elseif ($age < 18) {
		$errors['datum'] = "Pro vytvoření účtu vám musí být  alespoň 18 let";
	}

	$txt = "";
	if (count($errors) > 0) {
    	header("Location: ../");
    	$_SESSION['errors'] = $errors;
	} else {
	    $email = $_POST['email'];
	    $password = $_POST['password'];
	    $username = $_POST['username'];
	    $pohlavi = $_POST['pohlavi'];
		$money = $_POST['money'];

	    $sql = "SELECT COUNT(*) FROM betusers WHERE email LIKE '%$email%'";
	    $sql_com = $db->prepare($sql);
	    $sql_com->execute();
	    $data = $sql_com->fetchColumn();

	    $sql = "SELECT COUNT(*) FROM betusers WHERE username LIKE '%$username%'";
	    $sql_com = $db->prepare($sql);
	    $sql_com->execute();
	    $stav = $sql_com->fetchColumn();

	    if ($data != 0) {
	        $errors['email'] = "Zadaný email už patří k jinému účtu.";
	        $_SESSION['errors'] = $errors;
        	header("Location: ../");
	    } elseif ($stav != 0) {
	    	$errors['username'] = "Toto uživatelské jméno již existuje.";
	        $_SESSION['errors'] = $errors;
        	header("Location: ../");
	    } else {
	        $hashedPassword = hash('whirlpool', $password);

	        $sql = "INSERT INTO betusers (email, username, account_balance, password, phonenumber, gender, dateofbirth) VALUES (:emailValue, :usernameValue, :moneyValue, :passwordValue, :telefonValue, :genderValue, :birthdayValue)";
	        $dataIns = [
	            ":emailValue" => $email,
	            ":usernameValue" => $username,
				":moneyValue" => $money,
	            ":passwordValue" => $hashedPassword,
	            ":telefonValue" => $phonenumber_format,
	            ":genderValue" => $pohlavi,
	            ":birthdayValue" => $dateOfBirth,
	        ];

	        $sql_com = $db->prepare($sql);
	        $stav2 = $sql_com->execute($dataIns);
	        var_dump($stav2);
	        if ($stav2) {
	            header("Location: ../../success/successreg.php");
	        } else {
	            header("Location: ../");
	        }
	    }
	}

?>
