<?php

    session_start();
	include_once "db.php";
    include_once "lib/errors.php";

	if (isset($_SESSION['success']) AND !empty($_SESSION['success'])) {
		$success = $_SESSION['success'];
	} else {
		$success = null;
	}

	get_error('name');
	get_error('password');

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" type="text/css" href="styles.css">
	<title>Log In</title>
</head>
<style>
	body {
    font-family: 'Arial', sans-serif;
    background-color: #f5f5f5;
    margin: 0;
    padding: 0;
	}

	#wrapper {
	    max-width: 400px;
	    margin: 50px auto;
	    background-color: #fff;
	    border-radius: 8px;
	    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
	}

	#header {
	    background-color: #3498db;
	    color: #fff;
	    text-align: center;
	    padding: 20px;
	    border-top-left-radius: 8px;
	    border-top-right-radius: 8px;
	}

	#form {
	    padding: 20px;
	}

	.input_field {
	    margin-bottom: 20px;
	}

	label {
	    display: block;
	    margin-bottom: 5px;
	    color: #333;
	}

	input {
	    width: 100%;
	    padding: 10px;
	    border: 1px solid #ccc;
	    border-radius: 5px;
	}

	.sbt {
	    background-color: #3498db;
	    color: #fff;
	    padding: 10px;
	    border: none;
	    border-radius: 5px;
	    cursor: pointer;
	}

	.sbt:hover {
	    background-color: #2980b9;
	}

	.success {
	    background-color: #2ecc71;
	    color: #fff;
	    padding: 10px;
	    border-radius: 5px;
	    margin-bottom: 20px;
	}

	.error {
	    background-color: #e74c3c;
	    color: #fff;
	    padding: 10px;
	    border-radius: 5px;
	    margin-bottom: 20px;
	}
</style>
<body>
	<div id="wrapper">
		<div id="header">
			<h1>Log In</h1>
		</div>
		<?php if ($success): ?>
			<div class="success">
				<p><?=$success?></p>
			</div>
		<?php endif; ?>
		<div id="form">
			<form action="act/loginAct.php" method="post">
				<div class="input_field">
					<label id="name">Name:</label>
					<input type="text" name="name">
				</div>
				<?php if (get_error('name')): ?>
					<div class="error">
						<p><?=get_error('name')?></p>
					</div>
				<?php endif; ?>
				<div class="input_field">
					<label id="password">Password:</label>
					<input type="password" name="password">
				</div>
				<?php if (get_error('password')): ?>
					<div class="error">
						<p><?=get_error('password')?></p>
					</div>
				<?php endif; ?>
				<div class="input_field">
					<input type="submit" class="sbt" value="Log In">
				</div>
			</form>
		</div>
	</div>
</body>
</html>
<?php
	
	unset($_SESSION['success']);
	unset($_SESSION['errors']);

?>